/********************************************************************************************************
                        Fachpraktikum Mechatronik WS2024/25 

   Aufgabe       :       Test_Poti_und_Displays.ino

   Betreuer      :       Marc Ebmeyer

   Autor         :       Anivesh Kumar && Marius Hoffknecht 

   Datum         :       Lippstadt,den 15.11.2024

   Letzte Änderung:       Lippstadt,den 15.01.2025


   Quellen        :    TFT_22_ILI9225.h bibliothek von Nkawu -> https://github.com/Nkawu/TFT_22_ILI9225
                       SSD1306Ascii.h && SSD1306AsciiWire.h bibliotheken von Bill Greiman -> https://github.com/greiman/SSD1306Ascii

  Status          :     iFertig

 *******************************************************************************************************/

#include "SSD1306Ascii.h"
#include "SSD1306AsciiWire.h"
#include "TFT_22_ILI9225.h"

const int Poti_Pin = A0;
int Pot_Val = 0;

const int TFT_RST = 8;
const int TFT_RS = 9;
const int TFT_CS = 10;  // SS
const int TFT_SDI = 11;  // MOSI
const int TFT_CLK = 13;  // SCK
const int TFT_LED = 0;   // 0 if wired to +5V directly

const int TFT_BRIGHTNESS = 200;   // 0 if wired to +5V directly

TFT_22_ILI9225 tft = TFT_22_ILI9225(TFT_RST, TFT_RS, TFT_CS, TFT_LED, TFT_BRIGHTNESS);
SSD1306AsciiWire oled1;


void setup() 
{
  Wire.begin();
  Wire.setClock(400000L);
  oled1.begin(&Adafruit128x32, 0x3C);
  oled1.setFont(System5x7);
  oled1.print("Hello world!");


  tft.begin();
  Serial.begin(9600);
}


void loop() 
{
  //tft.fillRectangle(0, 0, 176, 220, COLOR_BLACK);
  //tft.clear();
  Pot_Val = map(analogRead(Poti_Pin),0,1024,0,256);
  LCD_Display_Output(Pot_Val);
  //tft.print(Pot_Val);
  //delay(50);

  //tft.setBackgroundColor(COLOR_BLACK);
}

void LCD_Display_Output(int x)
{
 String Value = String(x); 
  tft.setOrientation(0);
  tft.setFont(Terminal12x16);
  if(x == 9 || x == 10 || x == 99|| x == 100|| x == 999 || x == 1000)
  {
    tft.drawText(10, 30, Value.c_str(), COLOR_RED);
    tft.clear();
  }
  else
  {
  tft.drawText(10, 30, Value.c_str(), COLOR_RED);
  }
}